/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import com.threerings.getdown.Log;
import com.threerings.getdown.launcher.Getdown;
import com.threerings.getdown.launcher.GetdownAppletConfig;
import com.threerings.getdown.launcher.ImageLoader;
import com.threerings.getdown.launcher.m;
import com.threerings.getdown.launcher.n;
import java.awt.Image;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import javax.swing.JApplet;
import netscape.javascript.JSObject;

public class GetdownApplet
extends JApplet
implements ImageLoader {
    protected GetdownAppletConfig _config;
    protected Getdown _getdown;
    protected String _errmsg;
    protected JSObject _messageCallback;
    protected ServerSocket _serverSocket;
    protected DataOutputStream _connectOut;

    public synchronized void setMessageCallback(JSObject jSObject) {
        this._messageCallback = jSObject;
    }

    public synchronized boolean sendMessage(String string) {
        if (this._connectOut != null) {
            try {
                this._connectOut.writeUTF(string);
                return true;
            }
            catch (IOException iOException) {
                Log.log.b("Error sending message to app.", "message", string, iOException);
            }
        }
        return false;
    }

    public void init() {
        this._config = new GetdownAppletConfig(this);
        try {
            try {
                this._config.init();
            }
            catch (Exception exception) {
                this._errmsg = exception.getMessage();
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object[] objectArray = GetdownApplet.loadCertificate("resource.crt");
            if (objectArray != null) {
                arrayList.add(objectArray);
            } else {
                Log.log.b("No resource certificate found, falling back to class signers", new Object[0]);
                for (Object object : GetdownApplet.class.getSigners()) {
                    if (!(object instanceof Certificate)) continue;
                    arrayList.add((Certificate)object);
                }
            }
            this._getdown = new m(this, this._config.appdir, null, arrayList, this._config.jvmargs, this._config.appargs);
            this._config.config(this._getdown);
            this._getdown.preInit();
            return;
        }
        catch (Exception exception) {
            if (this._errmsg == null) {
                this._errmsg = exception.getMessage();
            }
            Log.log.b("init() failed.", exception);
            return;
        }
    }

    protected void startConnectServer() throws IOException {
        this._serverSocket = new ServerSocket(0, 0, InetAddress.getByName(null));
        Object object = String.valueOf(this._serverSocket.getLocalPort());
        Log.log.a("Listening for connections from launched app.", "port", object);
        System.setProperty("app.com.threerings.getdown.connectPort", (String)object);
        object = new n(this, "ConnectServer");
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    public Image loadImage(String string) {
        try {
            return this.getImage(new URL(this.getDocumentBase(), string));
        }
        catch (MalformedURLException malformedURLException) {
            Log.log.b("Failed to load background image", "path", string, malformedURLException);
            return null;
        }
    }

    public void start() {
        if (this._errmsg != null) {
            this._getdown.fail(this._errmsg);
            return;
        }
        try {
            this._getdown.start();
            return;
        }
        catch (Exception exception) {
            Log.log.b("start() failed.", exception);
            return;
        }
    }

    public void stop() {
        this._getdown.interrupt();
        this._getdown._app.releaseLock();
    }

    public synchronized void destroy() {
        if (this._serverSocket != null) {
            try {
                this._serverSocket.close();
            }
            catch (IOException iOException) {
                Log.log.b("Error closing server socket.", iOException);
            }
        }
        if (this._connectOut != null) {
            try {
                this._connectOut.writeUTF("CLOSE");
                this._connectOut.close();
                Log.log.a("Disconnected from app.", new Object[0]);
                return;
            }
            catch (IOException iOException) {
                Log.log.b("Error closing connect socket/output stream.", iOException);
            }
        }
    }

    protected boolean writeToFile(File file, String string) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            printStream.println(string);
            printStream.close();
            return true;
        }
        catch (IOException iOException) {
            Log.log.b("Failed to create '" + file + "'.", iOException);
            return false;
        }
    }

    protected static Certificate loadCertificate(String object) {
        Certificate certificate;
        object = GetdownApplet.class.getClassLoader().getResource((String)object);
        if (object == null) {
            return null;
        }
        object = ((URL)object).openStream();
        try {
            certificate = CertificateFactory.getInstance("X.509").generateCertificate((InputStream)object);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)object).close();
                throw throwable;
            }
            catch (CertificateException certificateException) {
                throw new RuntimeException(certificateException);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        ((InputStream)object).close();
        return certificate;
    }
}

